/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions;

import java.util.ServiceLoader;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.DefaultOptionsHandlerException;
import net.blay09.mods.defaultoptions.InternalMethodsImpl;
import net.blay09.mods.defaultoptions.api.DefaultOptionsAPI;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.api.DefaultOptionsPlugin;

public class DefaultOptionsInitializer {
    public static void preLoad() {
        DefaultOptionsInitializer.loadDefaults(DefaultOptionsLoadStage.PRE_LOAD);
    }

    public static void postLoad(ClientStartedEvent event) {
        for (DefaultOptionsHandler handler : DefaultOptions.getDefaultOptionsHandlers()) {
            if (handler.hasDefaults()) continue;
            try {
                handler.saveCurrentOptionsAsDefault();
            }
            catch (DefaultOptionsHandlerException e) {
                DefaultOptions.logger.warn("Failed to create initial default options from current options for {}", (Object)e.getHandlerId(), (Object)e);
            }
        }
        DefaultOptionsInitializer.loadDefaults(DefaultOptionsLoadStage.POST_LOAD);
    }

    private static void loadDefaults(DefaultOptionsLoadStage stage) {
        for (DefaultOptionsHandler handler : DefaultOptions.getDefaultOptionsHandlers()) {
            if (!handler.shouldLoadDefaults() || handler.getLoadStage() != stage) continue;
            try {
                DefaultOptions.logger.info("Loaded default options for {}", (Object)handler.getId());
                handler.loadDefaults();
            }
            catch (DefaultOptionsHandlerException e) {
                DefaultOptions.logger.error("Failed to load default options for {}", (Object)e.getHandlerId(), (Object)e);
            }
        }
    }

    static {
        DefaultOptionsAPI.__internalMethods = new InternalMethodsImpl();
        ServiceLoader<DefaultOptionsPlugin> loader = ServiceLoader.load(DefaultOptionsPlugin.class);
        loader.forEach(DefaultOptionsPlugin::initialize);
    }
}

